/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.usage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.Superplan;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class IslandFlooder {
    private List<Iterator<WorkplaceActivity>> iterators;
    private List<WorkplaceActivity> currentWas;
    private long t;
    private long remaining;
    private final int n;

    public IslandFlooder(@Nonnull Superplan superplan, @Nonnull CapabilityIsland island, long from, long normtime) {
        Preconditions.checkArgument(normtime >= 0L, "normtime cannot be negative");
        Preconditions.checkNotNull(island, "island cannot be null");
        Preconditions.checkNotNull(superplan, "superplan cannot be null");
        Plan plan = superplan.getPlan();
        List<Workplace> wps = island.getWorkplaces();
        this.n = wps.size();
        this.iterators = Lists.newArrayListWithCapacity(this.n);
        this.currentWas = Lists.newArrayListWithCapacity(this.n);
        for (int i = 0; i < this.n; ++i) {
            this.iterators.add(plan.getWorkplaceSchedule(wps.get(i)).forwardIteratorWithBubbles(from, true));
            this.currentWas.add(null);
            this.iterToNextFree(i);
        }
        this.remaining = normtime;
        this.t = from;
    }

    public long flood() {
        while (this.remaining > 0L) {
            WorkplaceActivity wa;
            int i;
            long minEnd = Long.MAX_VALUE;
            int activeCnt = 0;
            for (i = 0; i < this.n; ++i) {
                wa = this.currentWas.get(i);
                if (wa == null) continue;
                if (wa.getStart() <= this.t) {
                    ++activeCnt;
                    if (wa.getEnd() >= minEnd) continue;
                    minEnd = wa.getEnd();
                    continue;
                }
                if (wa.getStart() >= minEnd) continue;
                minEnd = wa.getStart();
            }
            if (activeCnt == 0) {
                this.t = Long.MAX_VALUE;
                for (i = 0; i < this.n; ++i) {
                    wa = this.currentWas.get(i);
                    if (wa == null || wa.getStart() >= this.t) continue;
                    this.t = wa.getStart();
                }
                if (this.t != Long.MAX_VALUE) continue;
                break;
            }
            long t2 = (long)activeCnt * (minEnd - this.t);
            if (minEnd == Long.MAX_VALUE || this.remaining - t2 < 0L) {
                this.t += (long)Math.ceil((double)this.remaining / (double)activeCnt);
                break;
            }
            this.t = minEnd;
            this.remaining -= t2;
            for (int i2 = 0; i2 < this.n; ++i2) {
                WorkplaceActivity wa2 = this.currentWas.get(i2);
                if (wa2 == null || wa2.getEnd() != minEnd) continue;
                this.iterToNextFree(i2);
            }
        }
        return this.t;
    }

    private void iterToNextFree(int i) {
        WorkplaceActivity wa = null;
        Iterator<WorkplaceActivity> iter = this.iterators.get(i);
        while (iter.hasNext()) {
            WorkplaceActivity wa2 = iter.next();
            if (!(wa2 instanceof RebuildActivity) && !(wa2 instanceof ActionActivity) && !(wa2 instanceof Bubble)) continue;
            wa = wa2;
            break;
        }
        this.currentWas.set(i, wa);
    }

    public static long flood(@Nonnull Superplan superplan, @Nonnull CapabilityIsland island, long from, long normtime) {
        return new IslandFlooder(superplan, island, from, normtime).flood();
    }
}

